#include "stdafx.h"
#include "win_demo.h"
#include "DialogPortParam.h"
#include "afxdialogex.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"
#include "sdks.h"
#include "common_tool.h"


extern int m_handle;
extern int m_chn_option;
IMPLEMENT_DYNAMIC(CDialogPortParam, CDialogEx)

CDialogPortParam::CDialogPortParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_PORT_PARAM, pParent)
{

}

CDialogPortParam::~CDialogPortParam()
{
}

jy_dev_port_t stPortParam;
BOOL CDialogPortParam::OnInitPortParam()
{
	CString strins;
	char *p_result = NULL;
	int nRet = sdks_dev_json_get_dev_port(m_handle, &p_result);
	if (!nRet)
	{
		memset(&stPortParam, 0, sizeof(jy_dev_port_t));
		json_perser_port_param(p_result, &stPortParam);
		strins.Format(_T("%d"), stPortParam.m_nControlPort);
		m_control_port.SetWindowTextA(strins);
		strins.Format(_T("%d"), stPortParam.m_nHttpPort);
		m_http_port.SetWindowTextA(strins);
		strins.Format(_T("%d"), stPortParam.m_nRTSPPort);
		m_rtsp_port.SetWindowTextA(strins);
		strins.Format(_T("%d"), stPortParam.m_nRTPPort);
		m_rtp_port.SetWindowTextA(strins);
		strins.Format(_T("%d"), stPortParam.m_nRTCPPort);
		m_rtcp_port.SetWindowTextA(strins);
		strins.Format(_T("%d"), stPortParam.m_nHttpsPort);
		m_https_port.SetWindowTextA(strins);
	}
	return TRUE;
}

void CDialogPortParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_CONTROL_PORT, m_control_port);
	DDX_Control(pDX, IDC_EDIT_HTTP_PORT, m_http_port);
	DDX_Control(pDX, IDC_EDIT_RTSP_PORT, m_rtsp_port);
	DDX_Control(pDX, IDC_EDIT_RTP_PORT, m_rtp_port);
	DDX_Control(pDX, IDC_EDIT_RTCP_PORT, m_rtcp_port);
	DDX_Control(pDX, IDC_EDIT_HTTPS_PORT, m_https_port);
}


BEGIN_MESSAGE_MAP(CDialogPortParam, CDialogEx)
	ON_BN_CLICKED(IDOK, &CDialogPortParam::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogPortParam::OnBnClickedOk()
{
	CDialogEx::OnOK();
	CString str_tmp;
	char *p_param = NULL;
	m_control_port.GetWindowText(str_tmp);
	stPortParam.m_nControlPort = _ttoi(str_tmp);
	m_http_port.GetWindowText(str_tmp);
	stPortParam.m_nHttpPort = _ttoi(str_tmp);
	m_rtsp_port.GetWindowText(str_tmp);
	stPortParam.m_nRTSPPort = _ttoi(str_tmp);
	m_rtp_port.GetWindowText(str_tmp);
	stPortParam.m_nRTPPort = _ttoi(str_tmp);
	m_rtcp_port.GetWindowText(str_tmp);
	stPortParam.m_nRTCPPort = _ttoi(str_tmp);
	m_https_port.GetWindowText(str_tmp);
	stPortParam.m_nHttpsPort = _ttoi(str_tmp);
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to set the network port?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_port_param(&stPortParam, &p_param);
		int nRet = sdks_dev_json_set_dev_port(m_handle, p_param);
		if (!nRet)
		{
			MessageBoxA("Port set successfully, device restart, client need to reconnect!");
			dev_reboot();
		}
	}
}
